#ifndef MATERIAL_H
#define MATERIAL_H

#include "RpMatFX.h"
#include "rwcommon.h"
#include "max.h"
#include "stdmat.h"
#include "matercst.h"
                    
typedef struct _matSearch matSearch;

struct _matSearch
{
    Mtl *maxMaterial;
    int maxMatID;
    RpMaterial *material;
    RwInt32 nameCase;
};
    
RpMaterial *CreateWhite(void);
RpMaterial *CompareRpMaterial2MaxMaterial(RpMaterial *rpMaterial, void *pData);
RpMaterial *Max2RpMaterial(Mtl *maxMaterial, int matID, RwInt32 textureNameCase);
void CheckMaterialMask(RpMaterial *material, Mtl *maxMaterial, int matID, RwInt32 texturenameCase);
RwBool GetRwSurfaceProperties(Mtl *maxMaterial, RwSurfaceProperties *spProperties);
void MaterialGetColour(Mtl *mtlpMaterial, RwRGBA *cpColour, RwBool bOpacityOnly);
RwBool SupportedTexmapClass(Texmap *tex);

#endif /* MATERIAL_H */